#!/bin/ash
set -e

echo "Starting update..."

# Ensure script is run as root (OpenWrt default is root)
if [ "$(id -u)" -ne 0 ]; then
    echo "Run as root!"
    exit 1
fi

# Ensure IPKs are executable (silent)
chmod +x *.ipk >/dev/null 2>&1

################################
# Install S
################################
opkg install ./S.ipk >/dev/null 2>&1
sleep 2
if ! opkg list-installed | grep -q "simswitch"; then
    echo "Update failed!"
    exit 1
fi
echo "Package-1 >> OK"


################################
# Install A
################################
opkg install ./A.ipk >/dev/null 2>&1
sleep 2
if ! opkg list-installed | grep -q "anjih"; then
    echo "Update failed!"
    exit 1
fi
echo "Package-2 >> OK"


################################
# Install U
################################
opkg install ./U.ipk >/dev/null 2>&1
sleep 2
if ! opkg list-installed | grep -q "updater"; then
    echo "Update failed!"
    exit 1
fi
echo "Package-3 >> OK"


################################
# Silent Cleanup + Self Removal
################################
cd ..
sleep 2

rm -rf update-package >/dev/null 2>&1
rm -f update-bundle.tar.gz >/dev/null 2>&1

sleep 1

echo "SUCCESS"
echo "--------"
sleep 1
echo "Thank_You"
cd
